/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.backup;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BackupFile
implements GenericObject {
    private File file = null;
    private Properties props = null;

    public BackupFile(File file) throws ApplicationException {
        if (file == null) {
            throw new ApplicationException(Application.getI18n().tr("Keine Backup-Datei angegeben"));
        }
        this.file = file;
        this.load();
    }

    public File getFile() {
        return this.file;
    }

    public Properties getProperties() {
        return this.props;
    }

    private void load() throws ApplicationException {
        if (this.props != null) {
            return;
        }
        ZipFile zip = null;
        InputStream is = null;
        try {
            zip = new ZipFile(this.file);
            ZipEntry entry = zip.getEntry("cfg/de.willuhn.jameica.plugin.PluginLoader.properties");
            if (entry == null) {
                throw new ApplicationException(Application.getI18n().tr("Backup enth\u00e4lt keine Plugin-Daten"));
            }
            is = zip.getInputStream(entry);
            if (is == null) {
                throw new ApplicationException(Application.getI18n().tr("Ung\u00fcltiges Backup-Format"));
            }
            this.props = new Properties();
            this.props.load(is);
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)("unable to read backup " + this.file.getAbsolutePath()), (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Backup nicht lesbar"));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Logger.error((String)("unable to close backup " + this.file.getAbsolutePath()), (Throwable)e);
                    throw new ApplicationException(Application.getI18n().tr("Backup nicht lesbar"));
                }
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    Logger.error((String)("unable to close backup " + this.file.getAbsolutePath()), (Throwable)e);
                    throw new ApplicationException(Application.getI18n().tr("Backup nicht lesbar"));
                }
            }
        }
    }

    public boolean equals(GenericObject other) throws RemoteException {
        if (other == null || !(other instanceof BackupFile)) {
            return false;
        }
        return this.file.equals(((BackupFile)other).file);
    }

    public Object getAttribute(String name) throws RemoteException {
        if ("created".equals(name)) {
            return new Date(this.file.lastModified());
        }
        if ("size".equals(name)) {
            return this.file.length();
        }
        return BeanUtil.get((Object)this.file, (String)name);
    }

    public String[] getAttributeNames() throws RemoteException {
        return new String[]{"name", "created"};
    }

    public String getID() throws RemoteException {
        return this.file.getAbsolutePath();
    }

    public String getPrimaryAttribute() throws RemoteException {
        return "name";
    }
}

